﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VRM.Integration.FTP.MVI.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.FTPDeterministicSearchRequest)]
    [DataContract]
    public class FTPDeterministicSearchRequest : MessageBase
    {
        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public string UserLastName { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string BirthDate { get; set; }

        [DataMember]
        public string SocialSecurityNumber { get; set; }

        [DataMember]
        public string EdiPi { get; set; }

        [DataMember]
        public DeterministicSearchType SearchType { get; set; }

    }

    public enum DeterministicSearchType
    {
        Edipi,
        SocialSecurity
    }
}
